-- Ahdoc msg for Applicant,Parent,FeePayer

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICANT_INSPCTN_DOC_ADHOC', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_INSPCTN_DOC_ADHOC');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'APPLICANT_INSPCTN_DOC_ADHOC');

INSERT INTO `adhoc_msg_recipient_type` (`msgRecipientTypeId`, `distrListProviderId`) VALUES (@msgRecipientId+1, @dtproviderId);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_INSPCTN_DOC_ADHOC');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    ard.`id` AS ID,
    T5.`firstName` AS FIRST_NAME,
    T5.`middleName` AS MIDDLE_NAME,
    T5.`lastName` AS LAST_NAME,
    T5.`emailId` AS EMAIL_ID,
    T5.`mobileNumber` AS MOBILE_NO,
    T5.`mobileCountryCode` AS MOBILE_CODE,
    dt.itemValue AS DOCUMENT_NAME,
    DATE_FORMAT(doc.submissionDate, '%d-%m-%Y') AS SUBMISSION_DATE,
    T4.printName AS INSPECTION_BY,
    DATE_FORMAT(ed.inspectionDate, '%d-%m-%Y') AS INSPECTION_DATE,
    DATE_FORMAT(ed.returnedDate, '%d-%m-%Y') AS RETURNED_DATE,
    retrnby.printName AS RETURNED_BY,
    ed.documentNote AS NOTE,
    ed.remark AS REMARK,
    b.printName AS BATCH,
    prg.programNameToBePrint AS PROG_PRINT_NAME,
    T12.academyName AS ACADEMY_NAME,
    T12.locationName AS LOCATION_NAME,
    T12.displayName AS ACADEMY_NAME_LOCATION,
    CONCAT(UCASE(LEFT(ard.status, 1)), LCASE(SUBSTRING(ard.status, 2))) AS STATUS
FROM
    application_required_documents ard
        LEFT JOIN
    application T1 ON T1.id = ard.applicationId
        LEFT JOIN
    document_types dt ON dt.id = ard.documentTypeId
        LEFT JOIN
    documents doc ON doc.id = ard.documentId
        LEFT JOIN
    extended_documents ed ON ed.documentId = doc.id
        LEFT JOIN
    users T2 ON ed.inspectionDoneBy = T2.id
        LEFT JOIN
    staffs T3 ON T2.id = T3.userId
        LEFT JOIN
    persons T4 ON T3.personId = T4.id
        LEFT JOIN
    applicant_person T5 ON T5.id = T1.applicantPersonId
        LEFT JOIN
    users retrnby ON ed.returnedBy = retrnby.id
        LEFT JOIN
    program_selection_process psp ON psp.id = ard.programSelectionProcessId
        LEFT JOIN
    prog_batch_seat_config pbsc ON pbsc.id = psp.programBatchSeatConfigId
        LEFT JOIN
    batches b ON b.id = pbsc.programBatchId
        LEFT JOIN
    programs prg ON prg.id = b.programId
        LEFT JOIN
    academy_location T12 ON T12.id = prg.academyLocationId
WHERE
    ard.id IN (namedParams)",'{
 "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "itemValue",
            "resultKey": "DOCUMENT_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "SUBMISSION_DATE",
            "resultKey": "SUBMISSION_DATE",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "INSPECTION_BY",
            "resultKey": "INSPECTION_BY",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "INSPECTION_DATE",
            "resultKey": "INSPECTION_DATE",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "RETURNED_DATE",
            "resultKey": "RETURNED_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "printName",
            "resultKey": "RETURNED_BY",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "documentNote",
            "resultKey": "NOTE",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "remark",
            "resultKey": "REMARK",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "printName",
            "resultKey": "BATCH",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "programNameToBePrint",
            "resultKey": "PROG_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 16
        }
    ]}');

-- set predefine msg template for committeee
SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @msgTemplateConfigId=(SELECT MAX(id) FROM `msg_template_config`);
SET @msgrecipienttypeId=(SELECT id FROM msg_recipient_type WHERE `code`='APPLICANT_INSPCTN_DOC_ADHOC');
INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`,`approvalRequired`,`approverId`,`whetherStaticMsg`,`status`,`availableForAdhocMsg`,`academyLocationId`,`authorName`,`authorId`) 
VALUES (@msgTemplateConfigId+1,'Inspection Document For Applicant',64,NULL,@msgrecipienttypeId,4,NULL,NULL,'Inspection Document For Applicant',NULL,0,NULL,0,'APPROVED',1,1,'System Admin',1);



INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Document Inspection Status','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#00000; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Hello&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]&nbsp;</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> Inspection of $recipientData[&quot;DOCUMENT_NAME&quot;] Submitted on $recipientData[&quot;SUBMISSION_DATE&quot;] is done on $recipientData[&quot;INSPECTION_DATE&quot;] by $recipientData[&quot;INSPECTION_BY&quot;] and your document is $recipientData[&quot;STATUS&quot;].</span></span></p>

			</td>
		</tr>
		<tr>
			
		</tr>
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Document Inspection Status','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#00000; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Hello&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]&nbsp;</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> Inspection of $recipientData[&quot;DOCUMENT_NAME&quot;] Submitted on $recipientData[&quot;SUBMISSION_DATE&quot;] is done on $recipientData[&quot;INSPECTION_DATE&quot;] by $recipientData[&quot;INSPECTION_BY&quot;] and your document is $recipientData[&quot;STATUS&quot;].</span></span></p>

			</td>
		</tr>
		<tr>
			
		</tr>
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Hello $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;] Inspection of $recipientData[&quot;DOCUMENT_NAME&quot;] Submitted on $recipientData[&quot;SUBMISSION_DATE&quot;] is done on $recipientData[&quot;INSPECTION_DATE&quot;] by $recipientData[&quot;INSPECTION_BY&quot;] and your document is $recipientData[&quot;STATUS&quot;].');


-- Inspection Document For Fee Payer

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'FEE_PAYR_INSPCTN_DOC_ADHOC', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='FEE_PAYR_INSPCTN_DOC_ADHOC');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'FEE_PAYR_INSPCTN_DOC_ADHOC');

INSERT INTO `adhoc_msg_recipient_type` (`msgRecipientTypeId`, `distrListProviderId`) VALUES (@msgRecipientId+1, @dtproviderId);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='FEE_PAYR_INSPCTN_DOC_ADHOC');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    ard.`id` AS ID,
    fpd.`firstName` AS FIRST_NAME,
    fpd.`middleName` AS MIDDLE_NAME,
    fpd.`lastName` AS LAST_NAME,
    fpd.`emailWork` AS EMAIL_ID,
    fpd.`mobileNumber` AS MOBILE_NO,
    fpd.`countryCode` AS MOBILE_CODE,
    dt.itemValue AS DOCUMENT_NAME,
    DATE_FORMAT(doc.submissionDate, '%d-%m-%Y') AS SUBMISSION_DATE,
    T4.printName AS INSPECTION_BY,
    DATE_FORMAT(ed.inspectionDate, '%d-%m-%Y') AS INSPECTION_DATE,
    DATE_FORMAT(ed.returnedDate, '%d-%m-%Y') AS RETURNED_DATE,
    retrnby.printName AS RETURNED_BY,
    ed.documentNote AS NOTE,
    ed.remark AS REMARK,
    b.printName AS BATCH,
    prg.programNameToBePrint AS PROG_PRINT_NAME,
    T12.academyName AS ACADEMY_NAME,
    T12.locationName AS LOCATION_NAME,
    T12.displayName AS ACADEMY_NAME_LOCATION,
    CONCAT(UCASE(LEFT(ard.status, 1)),
            LCASE(SUBSTRING(ard.status, 2))) AS STATUS
FROM
    application_required_documents ard
        LEFT JOIN
    application T1 ON T1.id = ard.applicationId
        LEFT JOIN
    document_types dt ON dt.id = ard.documentTypeId
        LEFT JOIN
    documents doc ON doc.id = ard.documentId
        LEFT JOIN
    extended_documents ed ON ed.documentId = doc.id
        LEFT JOIN
    users T2 ON ed.inspectionDoneBy = T2.id
        LEFT JOIN
    staffs T3 ON T2.id = T3.userId
        LEFT JOIN
    persons T4 ON T3.personId = T4.id
        INNER JOIN
    fee_payer_detail fpd ON fpd.applicantPersonId = T1.applicantPersonId
        LEFT JOIN
    applicant_person T5 ON T5.id = fpd.applicantPersonId
        LEFT JOIN
    users retrnby ON ed.returnedBy = retrnby.id
        LEFT JOIN
    program_selection_process psp ON psp.id = ard.programSelectionProcessId
        LEFT JOIN
    prog_batch_seat_config pbsc ON pbsc.id = psp.programBatchSeatConfigId
        LEFT JOIN
    batches b ON b.id = pbsc.programBatchId
        LEFT JOIN
    programs prg ON prg.id = b.programId
        LEFT JOIN
    academy_location T12 ON T12.id = prg.academyLocationId
WHERE
    ard.id IN (namedParams) and fpd.applicantPersonId is not null group by fpd.applicantPersonId order by fpd.id asc limit 1",'{
 "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "itemValue",
            "resultKey": "DOCUMENT_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "SUBMISSION_DATE",
            "resultKey": "SUBMISSION_DATE",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "INSPECTION_BY",
            "resultKey": "INSPECTION_BY",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "INSPECTION_DATE",
            "resultKey": "INSPECTION_DATE",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "RETURNED_DATE",
            "resultKey": "RETURNED_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "printName",
            "resultKey": "RETURNED_BY",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "documentNote",
            "resultKey": "NOTE",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "remark",
            "resultKey": "REMARK",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "printName",
            "resultKey": "BATCH",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "programNameToBePrint",
            "resultKey": "PROG_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 16
        }
    ]}');

-- set predefine msg template for committeee
SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @msgTemplateConfigId=(SELECT MAX(id) FROM `msg_template_config`);
SET @msgrecipienttypeId=(SELECT id FROM msg_recipient_type WHERE `code`='FEE_PAYR_INSPCTN_DOC_ADHOC');
INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`,`approvalRequired`,`approverId`,`whetherStaticMsg`,`status`,`availableForAdhocMsg`,`academyLocationId`,`authorName`,`authorId`) 
VALUES (@msgTemplateConfigId+1,'Inspection Document For Fee Payer',64,NULL,@msgrecipienttypeId,4,NULL,NULL,'Inspection Document For Fee Payer',NULL,0,NULL,0,'APPROVED',1,1,'System Admin',1);



INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Document Inspection Status','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#00000; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Hello&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]&nbsp;</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> Inspection of $recipientData[&quot;DOCUMENT_NAME&quot;] Submitted on $recipientData[&quot;SUBMISSION_DATE&quot;] is done on $recipientData[&quot;INSPECTION_DATE&quot;] by $recipientData[&quot;INSPECTION_BY&quot;] and your document is $recipientData[&quot;STATUS&quot;].</span></span></p>

			</td>
		</tr>
		<tr>
			
		</tr>
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'2',NULL,'Hello $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;] Inspection of $recipientData[&quot;DOCUMENT_NAME&quot;] Submitted on $recipientData[&quot;SUBMISSION_DATE&quot;] is done on $recipientData[&quot;INSPECTION_DATE&quot;] by $recipientData[&quot;INSPECTION_BY&quot;] and your document is $recipientData[&quot;STATUS&quot;].');


-- Inspection Document For Father


SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'FATHER_INSPCTN_DOC_ADHOC', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='FATHER_INSPCTN_DOC_ADHOC');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'FATHER_INSPCTN_DOC_ADHOC');

INSERT INTO `adhoc_msg_recipient_type` (`msgRecipientTypeId`, `distrListProviderId`) VALUES (@msgRecipientId+1, @dtproviderId);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='FATHER_INSPCTN_DOC_ADHOC');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    ard.`id` AS ID,
    T5.`firstName` AS FIRST_NAME,
    T5.`middleName` AS MIDDLE_NAME,
    T5.`lastName` AS LAST_NAME,
    T5.`emailId` AS EMAIL_ID,
    T5.`mobileNumber` AS MOBILE_NO,
    T5.`mobileCountryCode` AS MOBILE_CODE,
	ap.`printName` AS APPLICANT_PRINTNAME,
    dt.itemValue AS DOCUMENT_NAME,
    DATE_FORMAT(doc.submissionDate, '%d-%m-%Y') AS SUBMISSION_DATE,
    T4.printName AS INSPECTION_BY,
    DATE_FORMAT(ed.inspectionDate, '%d-%m-%Y') AS INSPECTION_DATE,
    DATE_FORMAT(ed.returnedDate, '%d-%m-%Y') AS RETURNED_DATE,
    retrnby.printName AS RETURNED_BY,
    ed.documentNote AS NOTE,
    ed.remark AS REMARK,
    b.printName AS BATCH,
    prg.programNameToBePrint AS PROG_PRINT_NAME,
    T12.academyName AS ACADEMY_NAME,
    T12.locationName AS LOCATION_NAME,
    T12.displayName AS ACADEMY_NAME_LOCATION,
    CONCAT(UCASE(LEFT(ard.status, 1)),
            LCASE(SUBSTRING(ard.status, 2))) AS STATUS
FROM
    application_required_documents ard
        LEFT JOIN
    application T1 ON T1.id = ard.applicationId
        LEFT JOIN
    document_types dt ON dt.id = ard.documentTypeId
        LEFT JOIN
    documents doc ON doc.id = ard.documentId
        LEFT JOIN
    extended_documents ed ON ed.documentId = doc.id
        LEFT JOIN
    users T2 ON ed.inspectionDoneBy = T2.id
        LEFT JOIN
    staffs T3 ON T2.id = T3.userId
        LEFT JOIN
    persons T4 ON T3.personId = T4.id
        INNER JOIN
    applicant_person_relationships apr ON apr.applicantPersonId = T1.applicantPersonId
        INNER JOIN
    applicant_person T5 ON T5.id = apr.relatedApplicantPersonId
		INNER JOIN
    applicant_person ap ON ap.id = T1.applicantPersonId
        LEFT JOIN
    users retrnby ON ed.returnedBy = retrnby.id
        LEFT JOIN
    program_selection_process psp ON psp.id = ard.programSelectionProcessId
        LEFT JOIN
    prog_batch_seat_config pbsc ON pbsc.id = psp.programBatchSeatConfigId
        LEFT JOIN
    batches b ON b.id = pbsc.programBatchId
        LEFT JOIN
    programs prg ON prg.id = b.programId
        LEFT JOIN
    academy_location T12 ON T12.id = prg.academyLocationId
WHERE
    ard.id IN (namedParams) AND apr.relationship = 'FATHER'",'{
 "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "itemValue",
            "resultKey": "DOCUMENT_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "SUBMISSION_DATE",
            "resultKey": "SUBMISSION_DATE",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "INSPECTION_BY",
            "resultKey": "INSPECTION_BY",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "INSPECTION_DATE",
            "resultKey": "INSPECTION_DATE",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "RETURNED_DATE",
            "resultKey": "RETURNED_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "printName",
            "resultKey": "RETURNED_BY",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "documentNote",
            "resultKey": "NOTE",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "remark",
            "resultKey": "REMARK",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "printName",
            "resultKey": "BATCH",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "programNameToBePrint",
            "resultKey": "PROG_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "printName",
            "resultKey": "APPLICANT_PRINTNAME",
            "displayCode": "",
            "displayOrder": 17
        }
    ]}');

-- set predefine msg template for committeee
SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @msgTemplateConfigId=(SELECT MAX(id) FROM `msg_template_config`);
SET @msgrecipienttypeId=(SELECT id FROM msg_recipient_type WHERE `code`='FATHER_INSPCTN_DOC_ADHOC');
INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`,`approvalRequired`,`approverId`,`whetherStaticMsg`,`status`,`availableForAdhocMsg`,`academyLocationId`,`authorName`,`authorId`) 
VALUES (@msgTemplateConfigId+1,'Inspection Document For Father',64,NULL,@msgrecipienttypeId,4,NULL,NULL,'Inspection Document For Father',NULL,0,NULL,0,'APPROVED',1,1,'System Admin',1);



INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Document Inspection Status','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#00000; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Hello&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]&nbsp;</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> Inspection of $recipientData[&quot;DOCUMENT_NAME&quot;] Submitted on $recipientData[&quot;SUBMISSION_DATE&quot;] is done on $recipientData[&quot;INSPECTION_DATE&quot;] by $recipientData[&quot;INSPECTION_BY&quot;] and your document is $recipientData[&quot;STATUS&quot;].</span></span></p>

			</td>
		</tr>
		<tr>
			
		</tr>
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'2',NULL,'Hello $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;] Inspection of $recipientData[&quot;DOCUMENT_NAME&quot;] Submitted on $recipientData[&quot;SUBMISSION_DATE&quot;] is done on $recipientData[&quot;INSPECTION_DATE&quot;] by $recipientData[&quot;INSPECTION_BY&quot;] and your document is $recipientData[&quot;STATUS&quot;].');


-- Inspection Document For Mother


SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'MOTHER_INSPCTN_DOC_ADHOC', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MOTHER_INSPCTN_DOC_ADHOC');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'MOTHER_INSPCTN_DOC_ADHOC');

INSERT INTO `adhoc_msg_recipient_type` (`msgRecipientTypeId`, `distrListProviderId`) VALUES (@msgRecipientId+1, @dtproviderId);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MOTHER_INSPCTN_DOC_ADHOC');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    ard.`id` AS ID,
    T5.`firstName` AS FIRST_NAME,
    T5.`middleName` AS MIDDLE_NAME,
    T5.`lastName` AS LAST_NAME,
    T5.`emailId` AS EMAIL_ID,
    T5.`mobileNumber` AS MOBILE_NO,
    T5.`mobileCountryCode` AS MOBILE_CODE,
	ap.`printName` AS APPLICANT_PRINTNAME,
    dt.itemValue AS DOCUMENT_NAME,
    DATE_FORMAT(doc.submissionDate, '%d-%m-%Y') AS SUBMISSION_DATE,
    T4.printName AS INSPECTION_BY,
    DATE_FORMAT(ed.inspectionDate, '%d-%m-%Y') AS INSPECTION_DATE,
    DATE_FORMAT(ed.returnedDate, '%d-%m-%Y') AS RETURNED_DATE,
    retrnby.printName AS RETURNED_BY,
    ed.documentNote AS NOTE,
    ed.remark AS REMARK,
    b.printName AS BATCH,
    prg.programNameToBePrint AS PROG_PRINT_NAME,
    T12.academyName AS ACADEMY_NAME,
    T12.locationName AS LOCATION_NAME,
    T12.displayName AS ACADEMY_NAME_LOCATION,
    CONCAT(UCASE(LEFT(ard.status, 1)),
            LCASE(SUBSTRING(ard.status, 2))) AS STATUS
FROM
    application_required_documents ard
        LEFT JOIN
    application T1 ON T1.id = ard.applicationId
        LEFT JOIN
    document_types dt ON dt.id = ard.documentTypeId
        LEFT JOIN
    documents doc ON doc.id = ard.documentId
        LEFT JOIN
    extended_documents ed ON ed.documentId = doc.id
        LEFT JOIN
    users T2 ON ed.inspectionDoneBy = T2.id
        LEFT JOIN
    staffs T3 ON T2.id = T3.userId
        LEFT JOIN
    persons T4 ON T3.personId = T4.id
        INNER JOIN
    applicant_person_relationships apr ON apr.applicantPersonId = T1.applicantPersonId
        INNER JOIN
    applicant_person T5 ON T5.id = apr.relatedApplicantPersonId
		INNER JOIN
    applicant_person ap ON ap.id = T1.applicantPersonId
        LEFT JOIN
    users retrnby ON ed.returnedBy = retrnby.id
        LEFT JOIN
    program_selection_process psp ON psp.id = ard.programSelectionProcessId
        LEFT JOIN
    prog_batch_seat_config pbsc ON pbsc.id = psp.programBatchSeatConfigId
        LEFT JOIN
    batches b ON b.id = pbsc.programBatchId
        LEFT JOIN
    programs prg ON prg.id = b.programId
        LEFT JOIN
    academy_location T12 ON T12.id = prg.academyLocationId
WHERE
    ard.id IN (namedParams) AND apr.relationship = 'MOTHER'",'{
 "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "itemValue",
            "resultKey": "DOCUMENT_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "SUBMISSION_DATE",
            "resultKey": "SUBMISSION_DATE",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "INSPECTION_BY",
            "resultKey": "INSPECTION_BY",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "INSPECTION_DATE",
            "resultKey": "INSPECTION_DATE",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "RETURNED_DATE",
            "resultKey": "RETURNED_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "printName",
            "resultKey": "RETURNED_BY",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "documentNote",
            "resultKey": "NOTE",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "remark",
            "resultKey": "REMARK",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "printName",
            "resultKey": "BATCH",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "programNameToBePrint",
            "resultKey": "PROG_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "printName",
            "resultKey": "APPLICANT_PRINTNAME",
            "displayCode": "",
            "displayOrder": 17
        }
    ]}');

-- set predefine msg template for committeee
SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @msgTemplateConfigId=(SELECT MAX(id) FROM `msg_template_config`);
SET @msgrecipienttypeId=(SELECT id FROM msg_recipient_type WHERE `code`='MOTHER_INSPCTN_DOC_ADHOC');
INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`,`approvalRequired`,`approverId`,`whetherStaticMsg`,`status`,`availableForAdhocMsg`,`academyLocationId`,`authorName`,`authorId`) 
VALUES (@msgTemplateConfigId+1,'Inspection Document For Mother',64,NULL,@msgrecipienttypeId,4,NULL,NULL,'Inspection Document For Mother',NULL,0,NULL,0,'APPROVED',1,1,'System Admin',1);



INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Document Inspection Status','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#00000; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Hello&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]&nbsp;</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> Inspection of $recipientData[&quot;DOCUMENT_NAME&quot;] Submitted on $recipientData[&quot;SUBMISSION_DATE&quot;] is done on $recipientData[&quot;INSPECTION_DATE&quot;] by $recipientData[&quot;INSPECTION_BY&quot;] and your document is $recipientData[&quot;STATUS&quot;].</span></span></p>

			</td>
		</tr>
		<tr>
			
		</tr>
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'2',NULL,'Hello $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;] Inspection of $recipientData[&quot;DOCUMENT_NAME&quot;] Submitted on $recipientData[&quot;SUBMISSION_DATE&quot;] is done on $recipientData[&quot;INSPECTION_DATE&quot;] by $recipientData[&quot;INSPECTION_BY&quot;] and your document is $recipientData[&quot;STATUS&quot;].');



